#include <iostream>
#include <iomanip>
#include <string>

#include "movegen.h"
#include "attack.h"

void gen_all_moves(cBoard &pboard, cMaterial &material, cMovelist &mlist, uint hashmove)
{
     const uint side = pboard.getside();
     uint ply = pboard.getply();

     uint *board = pboard.p2board();
     uint piece,sq,i,pcenum,tsq;
     const int *movedir = NULL;

     mlist.resetcount(pboard.getply());
     mlist.setpvmove(hashmove);

     //sliders - B,R,Q
     for(i = 0; i < 3; ++i)
     {
       piece = sliders[side][i];
       ASS(piecegood(piece));
       ASS(isslide[piece]==1);
       pcenum = material.getpcenum(piece);
       ASS(pcenum<maxpiecenum);

       while(pcenum)
       {
         sq = material.getpcesq(piece, pcenum);
          ASS(onbrd(sq));
          ASS(board[sq]==piece);
          for(movedir = dirPieces[piece]; *movedir ; movedir++)
          {
            for(tsq = sq+*movedir; !(tsq & 0x88); tsq += *movedir)
            {
              ASS(onbrd(tsq));
              if(board[tsq]==pE)
              {
                mlist.addmove(sq, tsq, board[tsq], FlagE, FlagE, ply, piece, pboard, material);
              }//addmove
              else if(pcecolour(board[tsq]) == (side^1))
              {
                   mlist.addmove(sq, tsq, board[tsq], FlagE, FlagE,ply, piece, pboard, material);
                   break;
              }//addcap
              else
              {
                 break;
              }
            }
         }
         pcenum--;
       }
     }//end for loop sliders

     //non sliders - N,K normal moves
     for(i = 0; i < 2; ++i)
     {
       piece = nonsliders[side][i];
       ASS(piecegood(piece));
       ASS(!isslide[piece]);
       pcenum = material.getpcenum(piece);
       ASS(pcenum<maxpiecenum);
       while(pcenum)
       {
         sq = material.getpcesq(piece, pcenum);
         ASS(onbrd(sq));
         ASS(board[sq]==piece);
         for(movedir = dirPieces[piece]; *movedir ; movedir++)
         {
           tsq = sq+*movedir;

           if(!(tsq & 0x88))
           {
              if(board[tsq]==pE || pcecolour(board[tsq])==(side^1))
              {
                 mlist.addmove(sq, tsq, board[tsq], FlagE, FlagE,ply, piece, pboard, material);
              }//addmove nonslider
           }
         }
         pcenum--;
       }
     }//end for loop non sliders

     //now pawns - first captures, then forward moves
     piece = pawns[side];
     ASS(piecegood(piece));
     ASS(!isslide[piece]);
     ASS(piece==pwP||piece==pbP);
     pcenum = material.getpcenum(piece);
     ASS(pcenum<maxpiecenum);
     while(pcenum)
     {
       sq = material.getpcesq(piece, pcenum);
       ASS(onbrd(sq));
       ASS(board[sq]==piece);
       for(i = 0; i < 2 ; ++i)
       {
        tsq = sq+dirPawn[piece][i];
        if(!(tsq & 0x88))
        {
           if(pcecolour(board[tsq]) == (side^1))
           {
             mlist.addpawnmove(sq, tsq, board[tsq], side,ply, piece, pboard, material);
           }
           else if(tsq == pboard.getenpas())
           {
             mlist.addmove(sq, tsq, board[tsq], FlagEP, FlagE,ply, piece, pboard, material);
           }
        }
       }//end of for loop for captures
       tsq = sq + dirPawn[piece][2];
       ASS(onbrd(tsq));//pawns don't get to rank 8, so +1sq north is always on the board
       if(pcecolour(board[tsq])== cN)
       {
         mlist.addpawnmove(sq, tsq, board[tsq], side, ply, piece, pboard, material);
         tsq += dirPawn[piece][2];
         if(ranks[sq]==startrank[side] && pcecolour(board[tsq])== cN)
         {
            mlist.addmove(sq, tsq, board[tsq], FlagE, FlagE, ply, piece, pboard, material);
         }
       }
       pcenum--;
     }

     //finally, the horror of king castling moves
     if(side==cW)
     {
     if (pboard.getcastle() & WCAKS)//King side
     { sq=E1;
       if (board[F1] == pE && board[G1] == pE)
       {
         if (!(isattack(pboard, material, cB, F1)))
         {
           if (!(isattack(pboard, material, cB, E1)))
           {
             tsq=G1;
             mlist.addmove(sq, tsq, board[tsq], FlagCA, FlagE,ply, piece, pboard, material);
           }
         }
       }
     }
     if (pboard.getcastle() & WCAQS)
     { sq=E1;
       if (board[C1] == pE && board[D1] == pE && board[B1] == pE)
       {
         if (!(isattack(pboard, material, cB, C1)))
         {
           if (!(isattack(pboard, material, cB, D1)))
           {
             if (!(isattack(pboard, material, cB, E1)))
             {
               tsq=C1;
                mlist.addmove(sq, tsq, board[tsq], FlagCA, FlagE,ply, piece, pboard, material);
             }
           }
         }
       }
     }
     }
     else
     {
     if (pboard.getcastle() & BCAKS)//King side
     { sq=E8;
       if (board[F8] == pE && board[G8] == pE)
       {
         if (!(isattack(pboard, material, cW, F8)))
         {
           if (!(isattack(pboard, material, cW, E8)))
           {
               tsq=G8;
               mlist.addmove(sq, tsq, board[tsq], FlagCA, FlagE,ply, piece, pboard, material);
           }
         }
       }
     }
     if (pboard.getcastle() & BCAQS)
     { sq=E8;
       if (board[C8] == pE && board[D8] == pE && board[B8] == pE)
       {
         if (!(isattack(pboard, material, cW, C8)))
         {
           if (!(isattack(pboard, material, cW, D8)))
           {
             if (!(isattack(pboard, material, cW, E8)))
             {
               tsq=C8;
               mlist.addmove(sq, tsq, board[tsq], FlagCA, FlagE,ply, piece, pboard, material);
             }
           }
         }
       }
     }
     }
}


void gen_all_captures(cBoard &pboard, cMaterial &material, cMovelist &mlist)
{
     const uint side = pboard.getside();
     uint ply = pboard.getply();

     uint *board = pboard.p2board();
     uint piece,sq,i,pcenum,tsq;
     const int *movedir = NULL;

     mlist.resetcount(ply);
     //sliders - B,R,Q
     for(i = 0; i < 3; ++i)
     {
       piece = sliders[side][i];
       ASS(piecegood(piece));
       ASS(isslide[piece]==1);
       pcenum = material.getpcenum(piece);
       ASS(pcenum<maxpiecenum);
       while(pcenum)
       {
         sq = material.getpcesq(piece, pcenum);
         ASS(onbrd(sq));
         ASS(board[sq]==piece);
          for(movedir = dirPieces[piece]; *movedir ; movedir++)
         {
            for(tsq = sq+*movedir; !(tsq & 0x88); tsq += *movedir)
            {
              ASS(onbrd(tsq));
              if(board[tsq]==pE)
              {
                continue;
              }
              else if(pcecolour(board[tsq]) == (side^1))
              {
                   mlist.addmove(sq, tsq, board[tsq], FlagE, FlagE,ply, piece, pboard, material);
                   break;
              }//addcap
              else
              {
                  break;
              }
            }
         }
         pcenum--;
       }
     }//end for loop sliders

     //non sliders - N,K normal moves
     for(i = 0; i < 2; ++i)
     {
       piece = nonsliders[side][i];
       ASS(piecegood(piece));
       ASS(!isslide[piece]);
       pcenum = material.getpcenum(piece);
       ASS(pcenum<maxpiecenum);
       while(pcenum)
       {
         sq = material.getpcesq(piece, pcenum);
         ASS(onbrd(sq));
         ASS(board[sq]==piece);
         for(movedir = dirPieces[piece]; *movedir ; movedir++)
         {
           tsq = sq+*movedir;
           if(!(tsq & 0x88))
           {
              if(pcecolour(board[tsq])==(side^1))
              {
                mlist.addmove(sq, tsq, board[tsq], FlagE, FlagE,ply, piece, pboard, material);
              }
           }
         }
         pcenum--;
       }
     }//end for loop non sliders

     //now pawns - first captures, then forward moves
     piece = pawns[side];
     ASS(piecegood(piece));
     ASS(!isslide[piece]);
     ASS(piece==pwP||piece==pbP);
     pcenum = material.getpcenum(piece);
     ASS(pcenum<maxpiecenum);
     while(pcenum)
     {
       sq = material.getpcesq(piece, pcenum);
       ASS(onbrd(sq));
       ASS(board[sq]==piece);
       for(i = 0; i < 2 ; ++i)
       {
        tsq = sq+dirPawn[piece][i];
        if(!(tsq & 0x88))
        {
           if(pcecolour(board[tsq]) == (side^1))
           {
             mlist.addpawnmove(sq, tsq, board[tsq], side,ply, piece, pboard, material);
           }
           else if(tsq == pboard.getenpas())
           {
             mlist.addmove(sq, tsq, board[tsq], FlagEP, FlagE,ply, piece, pboard, material);
           }
        }
       }
       pcenum--;
     }

}
